function x = GornjeTrougaoniSistem( A, b )

[m, n] = size( A );
[k, l] = size( b );
if m ~= n
    error( 'GRESKA: Matrica mora da bude kvadratna!!!' )
elseif l ~= 1
    error( 'GRESKA: Vektor b mora da bude vektor kolona!!!' )
elseif m ~= k
    error( 'GRESKA: Vektor b mora da bude iste dimenzije kao i matrica A!!!' )
else
    for i = 2 : m
        for j = 1 : i - 1
            if A( i, j ) ~= 0
                error( 'GRESKA: Matrica mora da bude gornje trougaona!!!' )
            end
        end
    end
    if abs( det( A ) ) <= eps
        error( 'GRESKA: Matrica mora da bude regularna!!!' )
    end
end

x = zeros( m, 1 );
x( m ) = b( m ) / A( m, m );
for j = m-1 : -1 : 1
    k = j + 1 : m;
    y = x( k );
    a = A( j, k )';
    x( j ) = ( b( j ) - sum( a .* y ) ) / A( j , j );
end